-- [ja] 画面の切り替えや効果音関係をこっちにまとめた 
-- [ja] 音の再生はupdate関数から 

local t = Def.ActorFrame{};

-- [ja] 対象グループ 
local sys_group=getenv("ExGroupName");
local exstage=GetEXFolderStage();
-- [ja] 選曲式か、強制確定か 
local sys_extype=GetGroupParameter(sys_group,"Extra"..exstage.."Type");
sys_extype=string.lower(sys_extype);

-- [ja] 曲情報の取得 
-- [ja] 選択可能な曲数（これを実行することにより、難易度別フラグの取得が可能） 
setenv("exsong_flag","");
local load_cnt=GetEXFolder_ChkSongs(sys_group,exstage);
local exsong_inf=getenv("exsong_inf");
local exsong_fol=getenv("exsong_fol");
setenv("exsong_flag","overlay");
setenv("exsong_chg",false);	-- [ja] 難易度または曲が変わったときに飛ばすメッセージ用 
setenv("sys_selected",false); -- [ja] 決定ボタン押下時 

-- [ja] システム的にキー操作を受け付けるタイミング 
local sys_key=false;
-- [ja] キャンセルボタンを押し続けているか確認用変数 
local sys_backcnt=0;
-- [ja] 決定ボタンを押してからの時間確認用変数 
local sys_startcnt=0;
-- [ja] 現在選択中の曲番号（1～曲数） 
local sys_selsong=1;
	setenv("sys_selsong",sys_selsong);
local sys_seldif={3,3};
-- [ja]1.323追加 
local exdefdif=string.lower(GetGroupParameter(sys_group,"Extra"..exstage.."Difficulty"));
if exdefdif=="beginner" then
	sys_seldif={1,1};
elseif exdefdif=="easy" then
	sys_seldif={2,2};
elseif exdefdif=="medium" then
	sys_seldif={3,3};
elseif exdefdif=="challenge" then
	sys_seldif={5,5};
elseif exdefdif=="edit" then
	sys_seldif={6,6};
else
	sys_seldif={4,4};
end;
--
sys_seldif_old={sys_seldif[1],sys_seldif[2]};
	setenv("sys_seldif",sys_seldif);

-- [ja] ゲージの状態を指定（この時点では定義だけで、実際には反映されない） 
local exlife=GetGroupParameter(sys_group,"Extra"..exstage.."LifeLevel");
if string.lower(exlife)=="hard" then
	setenv("ExLifeLevel","Hard");
elseif string.lower(exlife)=="1" then
	setenv("ExLifeLevel","1");
elseif string.lower(exlife)=="2" then
	setenv("ExLifeLevel","2");
elseif string.lower(exlife)=="3" then
	setenv("ExLifeLevel","3");
elseif string.lower(exlife)=="4" then
	setenv("ExLifeLevel","4");
elseif string.lower(exlife)=="5" then
	setenv("ExLifeLevel","5");
elseif string.lower(exlife)=="6" then
	setenv("ExLifeLevel","6");
elseif string.lower(exlife)=="7" then
	setenv("ExLifeLevel","7");
elseif string.lower(exlife)=="8" then
	setenv("ExLifeLevel","8");
elseif string.lower(exlife)=="9" then
	setenv("ExLifeLevel","9");
elseif string.lower(exlife)=="10" then
	setenv("ExLifeLevel","10");
elseif string.lower(exlife)=="pfc" or string.lower(exlife)=="w2fc" then
	setenv("ExLifeLevel","PFC");
elseif string.lower(exlife)=="mfc" or string.lower(exlife)=="w1fc" then
	setenv("ExLifeLevel","MFC");
elseif string.lower(exlife)=="ultimate" then
	setenv("ExLifeLevel","Ultimate");
elseif string.lower(exlife)=="hardnorecover" or string.lower(exlife)=="hex1" then
	setenv("ExLifeLevel","HardNoRecover");
elseif string.lower(exlife)=="norecover" or string.lower(exlife)=="ex1" then
	setenv("ExLifeLevel","NoRecover");
elseif string.lower(exlife)=="suddendeath" or string.lower(exlife)=="ex2" then
	setenv("ExLifeLevel","Suddendeath");
else
	setenv("ExLifeLevel","Normal");
end;

local sys_option=false;

local snd_cancel=false;
local snd_start=false;
local snd_up=false;
local snd_down=false;
local snd_chgdif=false;
local snd_chgsong=false;
-- [ja] サウンドとキー操作　
t[#t+1] = Def.ActorFrame {
	OnCommand=function(self)
		if load_cnt<=0 then
			SCREENMAN:SetNewScreen("ScreenSelectMusic");
		end;
		self:queuecommand("SetSong");
		if sys_extype=="song" then
			self:queuecommand("TypeSong");
		else
			SOUND:PlayAnnouncer("-waiei select exmusic intro");
			self:sleep(EXF_BEGIN_WAIT()+0.5);
			self:queuecommand("KeyUnLock");
		end;
	end;
	KeyUnLockCommand=function(self)
		sys_key=true;
	end;
	TypeSongCommand=function(self)
		self:finishtweening();
		setenv("ExFolderFlag","Ex"..exstage.."GamePlay");
		SCREENMAN:SetNewScreen("ScreenStageInformation");
	end;
	SetSongCommand=function(self)
		song=GetFolder2Song(sys_group,exsong_fol[sys_selsong]);
		GAMESTATE:SetCurrentSong(song);	--[ja] 強制曲設定 
		sys_seldif={sys_seldif_old[1],sys_seldif_old[2]};
		for pn=1,2 do
			while(not exsong_inf[exsong_fol[sys_selsong].."-"..Difficulty[sys_seldif[pn]]]) do
				if sys_seldif_old[pn]>3 then
					sys_seldif[pn]=sys_seldif[pn]-1;
					if sys_seldif[pn]<1 then
						sys_seldif[pn]=6;
					end;
				else
					sys_seldif[pn]=sys_seldif[pn]+1;
					if sys_seldif[pn]>6 then
						sys_seldif[pn]=1;
					end;
				end;
			end;
			GAMESTATE:SetCurrentSteps('PlayerNumber_P'..pn,
				song:GetOneSteps(GAMESTATE:GetCurrentSteps(GAMESTATE:GetMasterPlayerNumber()):GetStepsType(),Difficulty[sys_seldif[pn]]));
		end;
		setenv("sys_selsong",sys_selsong);
		setenv("sys_seldif",sys_seldif);
		setenv("exsong_chg",true);
	end;
	CodeCommand=function(self,params)
		if sys_key and GAMESTATE:IsHumanPlayer(params.PlayerNumber) and sys_extype~="song" then
			local p=(params.PlayerNumber==PLAYER_1) and 1 or 2;
			setenv("sys_move","nil");
			if params.Name == 'BackD' then
				if sys_startcnt==0 and sys_backcnt==0 then
					sys_backcnt=20;
				end;
			elseif params.Name=="BackU" and sys_backcnt>0 then
				sys_backcnt=0;
			elseif (params.Name=="Start" or params.Name=="Center") and not sys_option then
				if sys_startcnt==0 then
					sys_startcnt=60;
					SOUND:PlayAnnouncer("select music comment hard");
					setenv("sys_selected",true);
				else
					sys_option=true
				end;
				snd_start=true;
			elseif (params.Name == 'Left' or params.Name == 'Left2' or params.Name == 'Left3') and sys_startcnt==0 then
				sys_selsong=sys_selsong-1;
				if sys_selsong<1 then
					sys_selsong=#exsong_fol;
				end;
				snd_chgsong=true;
				setenv("sys_move","right");
				self:queuecommand("SetSong");
			elseif (params.Name == 'Right' or params.Name == 'Right2' or params.Name == 'Right3') and sys_startcnt==0 then
				sys_selsong=sys_selsong+1;
				if sys_selsong>#exsong_fol then
					sys_selsong=1;
				end;
				snd_chgsong=true;
				setenv("sys_move","left");
				self:queuecommand("SetSong");
			elseif (params.Name == 'Up' or params.Name == 'Up2' or params.Name == 'Up3') and sys_startcnt==0 then
				if sys_seldif[p]-1>=1 and
					exsong_inf[exsong_fol[sys_selsong].."-"..Difficulty[sys_seldif[p]-1]] then
					sys_seldif[p]=sys_seldif[p]-1;
					snd_chgdif=true;
					sys_seldif_old={sys_seldif[1],sys_seldif[2]};
					setenv("exsong_chg",true);
					GAMESTATE:SetCurrentSteps('PlayerNumber_P'..p,
						song:GetOneSteps(GAMESTATE:GetCurrentStyle():GetStepsType(),Difficulty[sys_seldif[p]]));
				end;
			elseif (params.Name == 'Down' or params.Name == 'Down2' or params.Name == 'Down3') and sys_startcnt==0 then
				if sys_seldif[p]+1<=6 and
					exsong_inf[exsong_fol[sys_selsong].."-"..Difficulty[sys_seldif[p]+1]] then
					sys_seldif[p]=sys_seldif[p]+1;
					snd_chgdif=true;
					sys_seldif_old={sys_seldif[1],sys_seldif[2]};
					setenv("exsong_chg",true);
					GAMESTATE:SetCurrentSteps('PlayerNumber_P'..p,
						song:GetOneSteps(GAMESTATE:GetCurrentStyle():GetStepsType(),Difficulty[sys_seldif[p]]));
				end;
			end;
		end;
	end;
	-- BGM 
	Def.Sound {
		InitCommand=function(self)
			if sys_extype~="song" then
				local bgm=GetGroupParameter(sys_group,"Extra"..GetEXFolderStage().."SelectBGM");
				if bgm~="" and FILEMAN:DoesFileExist("/Songs/"..sys_group.."/"..bgm)  then
					self:load("/Songs/"..sys_group.."/"..bgm);
				elseif bgm~="" and FILEMAN:DoesFileExist("/AdditionalSongs/"..sys_group.."/"..bgm) then
					self:load("/AdditionalSongs/"..sys_group.."/"..bgm);
				else
					self:load(THEME:GetPathS("ScreenSelectMusic","loop music"));
				end;
				self:stop();
				self:sleep(0.5);
				self:queuecommand("Play");
			end;
		end;
		PlayCommand=cmd(play);
	};
};
-- [ja] 決定 
t[#t+1] = LoadActor(THEME:GetPathS("Common","start")) .. {
	Name="SND_START";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_start=false;
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("Common","value")) .. {
	Name="SND_CHGDIF";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_chgdif=false;
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("Common","Cancel")) .. {
	Name="SND_CANCEL";
	PlayCommand=function(self)
		self:stop();
	--	self:play();
		snd_cancel=false;
		GAMESTATE:ApplyGameCommand( "mod,bar");
		MESSAGEMAN:Broadcast( "SongOptionsChanged" );
		EXF_Cancel();
		SCREENMAN:GetTopScreen():Cancel();
	end;
};
t[#t+1] = LoadActor(THEME:GetPathS("MusicWheel","change")) .. {
	Name="SND_CHGSONG";
	PlayCommand=function(self)
		self:stop();
		self:play();
		snd_chgsong=false;
	end;
};
if sys_extype=="song" then
	t[#t+1] = Def.Quad{
		InitCommand=cmd(FullScreen;diffuse,Color("Black"));
	};
else
	t[#t+1] = LoadActor(THEME:GetPathB("ScreenWithMenuElements","in"));
end;

-- [ja]最初だけ背景どーんと表示はいらない？（画面パーツが上から降ってくるため） 
--[[
local bg=GetGroupParameter(sys_group,"Extra"..GetEXFolderStage().."BackGround");
local fn=split("%.",bg);
if bg~="" and FILEMAN:DoesFileExist("/Songs/"..sys_group.."/"..bg)  then
	t[#t+1] = Def.ActorFrame{
		InitCommand=function(self)
			if string.lower(fn[#fn])~="lua" then
				self:Center();
			else
				local f=OpenFile("/AdditionalSongs/"..sys_group.."/"..bg);
				local data=string.lower(f:Read());
				CloseFile(f);
				if string.find(data,"diffuse",1,true) then
					self:zoom(0);
				end;
			end;
		end;
		LoadActor("/Songs/"..sys_group.."/"..bg)..{
			OnCommand=cmd(sleep,0.5;diffusealpha,1;linear,0.3;diffusealpha,0;);
		};
	};
elseif bg~="" and FILEMAN:DoesFileExist("/AdditionalSongs/"..sys_group.."/"..bg) then
	t[#t+1] = Def.ActorFrame{
		InitCommand=function(self)
			if string.lower(fn[#fn])~="lua" then
				self:Center();
			else
				local f=OpenFile("/AdditionalSongs/"..sys_group.."/"..bg);
				local data=string.lower(f:Read());
				CloseFile(f);
				if string.find(data,"diffuse",1,true) then
					self:zoom(0);
				end;
			end;
		end;
		LoadActor("/AdditionalSongs/"..sys_group.."/"..bg)..{
			OnCommand=cmd(sleep,0.5;diffusealpha,1;linear,0.3;diffusealpha,0;);
		};
	};
end;
--]]

local oTime=0;
local nTime=0;
local m=PREFSMAN:GetPreference("MenuTimer");
local mTimer=tonumber(THEME:GetMetric("ScreenSelectExMusic","TimerSeconds"));
local mflag=false;
local wait=1.0/60;
local function update(self,dt)
	nTime=nTime+dt;
	if m and not mflag and (mTimer-nTime)<=0 then
		mflag=true;
		snd_start=true;
		sys_startcnt=60;
		setenv("sys_selected",true);
	end;
	-- [ja] 1回分の処理 
	if nTime-oTime>wait then
		if sys_backcnt>0 then
			sys_backcnt=sys_backcnt-1;
			if sys_backcnt<=0 then
				snd_cancel=true;
			end;
		end;
		if sys_startcnt>0 then
			sys_startcnt=sys_startcnt-1;
			if sys_startcnt<=0 then
				-- [ja] Random使用時のみ特殊処理 
				if exsong_inf[exsong_fol[sys_selsong].."-Random"]~="" then
					song=GetFolder2Song(sys_group,exsong_inf[exsong_fol[sys_selsong].."-Random"]);
					if song then
						GAMESTATE:SetCurrentSong(song);	--[ja] 強制曲設定 
					end;
				end;
				setenv("ExFolderFlag","Ex"..exstage.."GamePlay");
				for pn=1,2 do
					GAMESTATE:SetCurrentSteps('PlayerNumber_P'..pn,
						song:GetOneSteps(GAMESTATE:GetCurrentStyle():GetStepsType(),Difficulty[sys_seldif[pn]]));
				end;
				if sys_option then
					SCREENMAN:SetNewScreen("ScreenPlayerOptions");
				else
					SCREENMAN:SetNewScreen("ScreenStageInformation");
				end;
			end;
		end;
		oTime=oTime+wait;
	end;
	if snd_cancel then
		local c_snd=self:GetChild("SND_CANCEL");
		c_snd:queuecommand("Play");
	end;
	if snd_start then
		local c_snd=self:GetChild("SND_START");
		c_snd:queuecommand("Play");
	end;
	if snd_chgsong then
		local c_snd=self:GetChild("SND_CHGSONG");
		c_snd:queuecommand("Play");
	end;
	if snd_chgdif then
		local c_snd=self:GetChild("SND_CHGDIF");
		c_snd:queuecommand("Play");
	end;
end;

if sys_extype~="song" then
	t.InitCommand=cmd(SetUpdateFunction,update);
end;

return t;